 /****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL]    Script Date: 01/30/2014 10:20:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL]
GO
/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL]    Script Date: 01/30/2014 10:20:13 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
-- Versao 2801
-- exec P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL 1,1,'2017-10-21',1
CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL]
						@CD_EMP INT=1, 
						@QT_MESES INT=1, 
						@DT_ATUAL DATETIME=NULL,
						@CD_FILIAL INT	WITH ENCRYPTION AS
SET NOCOUNT ON
INSERT INTO LOG_ANALISE_DIARIA 
SELECT @CD_FILIAL, 'INICIO DO PROCEDIMENTO - P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL - 2801', GETDATE()
DECLARE @FLAGCONTROLETIPOCOMPRAFILIAL INT

SET @FLAGCONTROLETIPOCOMPRAFILIAL=ISNULL((SELECT 
												VALOR AS ORC_PED_CP
											  FROM 
													PRC_EMP_CONFIG
											  WHERE 
													CD_EMP	= @CD_EMP 
													AND	CD_CHAVE = 'FLAG_CONTROLE_TIPO_COMPRA_FILIAL'),0);

DECLARE 
		@DT_BASE DATETIME, 
		@ANO_INI INT, 
		@MES_INI INT, 
		@ANO_FIM INT, 
		@MES_FIM INT, 
		@INI INT, 
		@FIM INT,
		@DT_INI_MES DATETIME, 
		@DT_FIM_MES DATETIME;

CREATE TABLE #ANALISE (CD_EMP 				INT,
						CD_FILIAL			INT,
						DT_VD				DATETIME,
						CD_PROD				INT,
						PART_QTDE			FLOAT,
						QT_VD_DIA			MONEY,
						QT_MEDIA_VD			MONEY,
						PART_VLR			FLOAT,
						VLR_MEDIO_VD		MONEY,
						COBERTURA			MONEY,
						QT_EST				MONEY,
						QT_EXCESSO			MONEY,
						LIMITE_EXCESSO		MONEY,
						FLAG_PART_INDIC		MONEY,
						QT_EST_EM_TERC		MONEY,	
						QT_EST_DE_TERC		MONEY,	
						QT_EST_DEPOSITOS	MONEY,
						MEDIAF				MONEY,
						QT_PEND_ENT			MONEY,
						QT_PEND_SAI			MONEY,
						QT_RESSUP_DIA		MONEY,
						QT_CP_DIA			MONEY,
						CD_SIGLA			INT,
						VLR_DESC_VD			MONEY,
						QT_DIAS_EXCESSO		MONEY,
						QT_RESSUP_PROX_DIA	MONEY, 
						CD_FABRIC				INT,
						CD_ARV_MERC_LINHA		INT,
						COMPRA_POR_SUPRIMENTO	INT,
						LJ_FLAG_PARTIC_INDIC	INT,
						FLAG_ANALISE_FALTAS		INT,
						STS_PROD_EMP			INT,
						STS_PROD_FILIAL			INT,
						EMAX					MONEY,
						ESEG					MONEY,
						QTDE_FACEAMENTO			MONEY,
						QTDE_FINANCIADO			MONEY,
						QTDE_LIMITADOR			MONEY,
						VLR_CUSTO				MONEY,
						VLR_CUSTO_MD			MONEY,
						VLR_TABELA				MONEY,
						VLR_OFERTA				MONEY,
						FLAG_NAO_PARTIC_INDIC_LINHA INT);

CREATE TABLE #EXCESSO (CD_EMP					INT, 
						CD_FILIAL				INT, 
						DT_ATUAL				DATETIME, 
						CD_PROD					INT, 
						CURVA					VARCHAR(5), 
						MEDIAF					MONEY, 
						COBERTURA				MONEY,
						QT_EST					MONEY, 
						QTDE_EXCESSO			MONEY,
						EMAX 					MONEY,
				 		QT_EST_EM_TERC			MONEY,	
						QT_EST_DE_TERC			MONEY,	
						QT_EST_DEPOSITOS		MONEY,
						QTDE_MEDIAF				MONEY,
						QT_PEND_ENT				MONEY,
						QT_PEND_SAI				MONEY,	
						QT_DIAS_EXCESSO			MONEY );

		CREATE TABLE #TBL_A ( CD_PROD		INT, 
								PART_QTDE	FLOAT,
								QT_MEDIA_VD	MONEY,
								PART_VLR	FLOAT);

		CREATE TABLE #TBL_V ( CD_PROD			INT,
								QTDE_IT			MONEY,
								VLR_TOTAL_VD	MONEY,
								VLR_DESC_VD		MONEY);


		CREATE TABLE #BASE2	(	CD_FILIAL		INT,
								CD_PROD			INT,
								QT_DIAS_CALCULO	MONEY,
								QT_DIAS_FALTA	MONEY);

		CREATE TABLE #BASE	(	CD_FILIAL		INT,
								CD_PROD			INT,
								QT_DIAS_CALCULO	MONEY,
								QT_DIAS_FALTA	MONEY);

--Calculo do periodo de analise
IF @DT_ATUAL IS NULL SELECT @DT_ATUAL=dbo.F_ONTEM();
 
	SELECT	@DT_BASE=DATEADD(mm, -1, @DT_ATUAL ),
			@ANO_FIM=YEAR(@DT_BASE),	@MES_FIM=MONTH(@DT_BASE), 
			@ANO_INI=@ANO_FIM,			@MES_INI=@MES_FIM-@QT_MESES+1;
	WHILE @MES_INI<=0 
		SELECT @MES_INI=@MES_INI+12,	@ANO_INI=@ANO_INI-1;

	SELECT 
		@INI=@ANO_INI*100+@MES_INI,	
		@FIM=@ANO_FIM*100+@MES_FIM;  
		
		
	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'REMOVE REGISTROS PREVIOS', GETDATE()
	--Limpa eventual dado previo do dia
	DELETE 
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO 
	WHERE 
		CD_FILIAL = @CD_FILIAL
		AND DT_VD=@DT_ATUAL 
		AND CD_EMP=@CD_EMP;
 

	--Processando faltas

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'BUSCA DADOS ANALISE MENSAL', GETDATE()

	DELETE FROM #TBL_A;
	DELETE FROM #TBL_V;

	INSERT INTO #TBL_A
	SELECT	
		CD_PROD, 
		PART_QTDE   = CONVERT(FLOAT, (SUM(PART_QTDE) / @QT_MESES)),
		QT_MEDIA_VD = CONVERT(FLOAT, (SUM(QTDE_TOTAL)/ @QT_MESES)),
		PART_VLR    = CONVERT(FLOAT, (SUM(PART_VLR)  / @QT_MESES))
	FROM EST_PROD_CPL_ANALISE
	WHERE 
		CD_EMP=@CD_EMP 
		AND CD_FILIAL=@CD_FILIAL 
		AND ANO*100+MES BETWEEN @INI AND @FIM
	GROUP BY CD_PROD;

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'INSERE DADOS DA VENDA', GETDATE()

	INSERT INTO #TBL_V
		SELECT	
			i.CD_PROD,
			CONVERT(FLOAT,SUM(i.QT_IT)), 
			CONVERT(FLOAT,SUM(i.TOT_IT - i.VLR_DESC_TOT_RAT)), 			
			SUM(ROUND(I.QT_IT * I.VLR_IT * I.TX_DESC / 100, 2) + I.VLR_OFERTA)
		FROM 
			PDV_VD v INNER JOIN PDV_VD_IT i ON
			v.CD_EMP = i.CD_EMP AND
			v.CD_FILIAL = i.CD_FILIAL AND
			v.CD_VD = i.CD_VD AND		
			v.DT_VD = i.DT_VD 
		WHERE 
			v.CD_EMP=@CD_EMP 
			AND v.CD_FILIAL=@CD_FILIAL 
			AND v.DT_VD =@DT_ATUAL
			AND v.ST_VD = 0 
			AND i.ST_IT = 1
		GROUP BY 
			i.CD_PROD;	
	 

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'INSERE DADOS ANALISE TEMPORARIA', GETDATE()

	INSERT INTO #ANALISE 
		(CD_EMP,	
		 CD_FILIAL, 
		 DT_VD, 
		 CD_PROD, 
		 PART_QTDE, 
		 QT_VD_DIA, 
		 QT_MEDIA_VD, 
		 PART_VLR, 
		 VLR_MEDIO_VD, 
		 COBERTURA, 
		 QT_EST, 
		 QT_EXCESSO, 
		 LIMITE_EXCESSO,
		 FLAG_PART_INDIC,
    	 QT_EST_EM_TERC,	
		 QT_EST_DE_TERC,	
		 QT_EST_DEPOSITOS,
		 MEDIAF,
		 QT_PEND_ENT,
		 QT_PEND_SAI,
		 QT_RESSUP_DIA,
		 QT_CP_DIA,
		 CD_SIGLA,
		 VLR_DESC_VD, 
		 QT_DIAS_EXCESSO,
		 QT_RESSUP_PROX_DIA,
		 CD_FABRIC,
		 CD_ARV_MERC_LINHA,
		 COMPRA_POR_SUPRIMENTO,
		 LJ_FLAG_PARTIC_INDIC,
		 FLAG_ANALISE_FALTAS,
		 STS_PROD_EMP,
		 STS_PROD_FILIAL,
		 EMAX,
		 ESEG,
		 QTDE_FACEAMENTO,
		 QTDE_FINANCIADO,
		 QTDE_LIMITADOR,
		 VLR_CUSTO,
		 VLR_CUSTO_MD,
		 VLR_TABELA,
		 VLR_OFERTA,
		 FLAG_NAO_PARTIC_INDIC_LINHA)

	SELECT 
		CD_EMP          = @CD_EMP,
		CD_FILIAL       = @CD_FILIAL, 
		DT_VD           = @DT_ATUAL, 
		CD_PROD         = ISNULL(a.CD_PROD, v.CD_PROD),
		PART_QTDE       = ISNULL(a.PART_QTDE, 0), 
		QTDE_IT         = ISNULL(v.QTDE_IT, 0),
		QT_MEDIA_VD     = ISNULL(a.QT_MEDIA_VD, 0),	
		PART_VLR        = ISNULL(a.PART_VLR, 0), 
		VLR_TOTAL_VD    = ISNULL(v.VLR_TOTAL_VD, 0),
		COBERTURA       = 0, 
		QT_EST          = 0, 
		QT_EXCESSO      = 0, 
		LIMITE_EXCESSO  = 0,
		FLAG_PART_INDIC = 0,
		QT_EST_EM_TERC	= 0,	
		QT_EST_DE_TERC	= 0,	
		QT_EST_DEPOSITOS= 0,
		MEDIAF			= 0,
	    QT_PEND_ENT		= 0,
		QT_PEND_SAI		= 0,
		QT_RESSUP_DIA	= 0,
		QT_CP_DIA		= 0,
		CD_SIGLA		= 0,
		VLR_DESC_VD		= ISNULL(VLR_DESC_VD,0),
		QT_DIAS_EXCESSO	= 0,
		QT_RESSUP_PROX_DIA=0,
		CD_FABRIC				=0,
		CD_ARV_MERC_LINHA		=0,
		COMPRA_POR_SUPRIMENTO	=0,
		LJ_FLAG_PARTIC_INDIC	=0,
		FLAG_ANALISE_FALTAS		=0,
		STS_PROD_EMP			=0,
		STS_PROD_FILIAL			=0,
		EMAX					=0,
		ESEG					=0,
		QTDE_FACEAMENTO			=0,
		QTDE_FINANCIADO			=0,
		QTDE_LIMITADOR			=0,
		VLR_CUSTO				=NULL,
		VLR_CUSTO_MD			=NULL,
		VLR_TABELA				=NULL,
		VLR_OFERTA				=NULL,
		0 AS FLAG_NAO_PARTIC_INDIC_LINHA
	FROM 
		#TBL_A a 
		FULL OUTER JOIN #TBL_V v ON 
		a.CD_PROD=v.CD_PROD;


	CREATE INDEX IX_TMP_ANALISE ON #ANALISE (CD_EMP, CD_FILIAL, CD_PROD)


	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'INSERIU DADOS ANALISE TEMPORARIA - ' + CONVERT(VARCHAR(MAX), (SELECT COUNT(*) FROM #ANALISE)) + ' REGISTROS' , GETDATE()


	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'ALTERA DADOS ESTOQUE E PENDENCIA ANALISE TEMPORARIA', GETDATE()


	IF (DATEADD(DAY, -2, GETDATE()) > @DT_ATUAL)
	BEGIN
	--Registra se o produto participa dos indicadores
		UPDATE a SET 
			a.FLAG_PART_INDIC	=	p.FLAG_ANALISE_EXC_COB,
			a.QT_EST_DEPOSITOS	=	CPL.QT_EST_DEPOSITOS,
			a.MEDIAF			=	CPL.MEDIAF,
			a.QT_PEND_ENT		=	0,
			a.QT_PEND_SAI		=	0,
			a.QT_RESSUP_DIA		=	0,
			a.QT_CP_DIA			=	0,
			a.CD_SIGLA			=	CPL.CD_SIGLA,
			A.QT_RESSUP_PROX_DIA=	0,
			A.CD_FABRIC				=p.CD_FABRIC,
			A.CD_ARV_MERC_LINHA		=arv.CD_ARV_MERC_LINHA,
			A.COMPRA_POR_SUPRIMENTO	=CASE WHEN @FLAGCONTROLETIPOCOMPRAFILIAL = 0 THEN ISNULL(P.COMPRA_POR_SUPRIMENTO,0) ELSE ISNULL(CPL.COMPRA_POR_SUPRIMENTO,0) END,
			A.LJ_FLAG_PARTIC_INDIC	=CASE WHEN F.FLAG_NAO_PARTIC_INDIC = 0 THEN 1 ELSE 0 END,
			A.FLAG_ANALISE_FALTAS	=P.FLAG_ANALISE_FALTAS,
			A.STS_PROD_EMP			=p.STS_PROD,
			A.STS_PROD_FILIAL		=CPL.STS_PROD,
			A.EMAX					=CPL.EMAX,
			A.ESEG					=CPL.ESEG,
			A.QTDE_FACEAMENTO		=CPL.QTDE_FACEAMENTO,
			A.QTDE_FINANCIADO		=CPL.QTDE_FINANCIADO,
			A.QTDE_LIMITADOR		=CPL.QTDE_LIMITADOR,
			A.VLR_CUSTO				=CPL.VLR_CUSTO,
			A.VLR_CUSTO_MD			=CPL.VLR_CUSTO_MD,
			A.VLR_TABELA			=vlr.VLR_TABELA,
			A.VLR_OFERTA			=vlr.VLR_OFERTA,
			a.FLAG_NAO_PARTIC_INDIC_LINHA = ISNULL(linha.FLAG_NAO_PARTIC_INDIC,0)
		FROM 
			#ANALISE a 
			INNER JOIN  EST_PROD p ON
			a.CD_EMP	= p.CD_EMP AND 
			a.CD_PROD	= p.CD_PROD 
			INNER JOIN  EST_PROD_CPL CPL ON
			a.CD_EMP	= CPL.CD_EMP AND 
			a.CD_FILIAL = CPL.CD_FILIAL AND
			a.CD_PROD	= CPL.CD_PROD 
			INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA arv ON
			a.CD_EMP	= arv.CD_EMP AND 
			a.CD_PROD	= arv.CD_PROD 
			INNER JOIN  EST_ARV_MERC_LINHA linha ON
			arv.CD_EMP	= linha.CD_EMP AND 
			arv.CD_ARV_MERC_LINHA	= linha.CD_ARV_MERC_LINHA 
			INNER JOIN  EST_PROD_PRECO vlr ON
			a.CD_EMP		= vlr.CD_EMP AND 
			a.CD_FILIAL		= vlr.CD_FILIAL AND
			a.CD_PROD		= vlr.CD_PROD  

			INNER JOIN  PRC_FILIAL f ON
			a.CD_EMP		= f.CD_EMP AND 
			a.CD_FILIAL		= f.CD_FILIAL  
		WHERE 
			a.DT_VD			=@DT_ATUAL 
			AND a.CD_EMP	=@CD_EMP
			AND a.CD_FILIAL	=@CD_FILIAL; 
		
		INSERT INTO LOG_ANALISE_DIARIA 
		SELECT @CD_FILIAL, 'ALTERA DADOS ESTOQUE E PENDENCIA ANALISE TEMPORARIA - ESTOQUE', GETDATE();
		UPDATE
			A
		SET
			a.QT_EST			=	c.QT_IT
		FROM
			#ANALISE a 
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, a.CD_PROD,@DT_ATUAL, 0) c;

		INSERT INTO LOG_ANALISE_DIARIA 
		SELECT @CD_FILIAL, 'ALTERA DADOS ESTOQUE E PENDENCIA ANALISE TEMPORARIA - ESTOQUE EM TERC', GETDATE();
		UPDATE
			A
		SET
			a.QT_EST_EM_TERC	=	E.QT_IT
		FROM
			#ANALISE a 
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, a.CD_PROD, @DT_ATUAL, 2) E

		INSERT INTO LOG_ANALISE_DIARIA 
		SELECT @CD_FILIAL, 'ALTERA DADOS ESTOQUE E PENDENCIA ANALISE TEMPORARIA - ESTOQUE DE TERC', GETDATE();
		UPDATE
			A
		SET
			a.QT_EST_DE_TERC	=	g.QT_IT
		FROM
			#ANALISE a 
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, a.CD_PROD, @DT_ATUAL, 3) g;
	END
	ELSE
	BEGIN
		UPDATE a SET 
			a.FLAG_PART_INDIC	=	p.FLAG_ANALISE_EXC_COB,
			a.QT_EST			=	c.QT_EST,
			a.QT_EST_EM_TERC	=	c.QT_EST_EM_TERC,	
			a.QT_EST_DE_TERC	=	c.QT_EST_DE_TERC,	
			a.QT_EST_DEPOSITOS	=	c.QT_EST_DEPOSITOS,
			a.MEDIAF			=	c.MEDIAF,
			a.QT_PEND_ENT		=	ISNULL(c.QT_PEND_ENT,0),
			a.QT_PEND_SAI		=	ISNULL(c.QT_PEND_SAI,0),
			a.QT_RESSUP_DIA		=	0,
			a.QT_CP_DIA			=	0,
			a.CD_SIGLA			=	c.CD_SIGLA,
			A.QT_RESSUP_PROX_DIA=	0,
			A.CD_FABRIC				=p.CD_FABRIC,
			A.CD_ARV_MERC_LINHA		=arv.CD_ARV_MERC_LINHA,
			A.COMPRA_POR_SUPRIMENTO	=CASE WHEN @FLAGCONTROLETIPOCOMPRAFILIAL = 0 THEN ISNULL(P.COMPRA_POR_SUPRIMENTO,0) ELSE ISNULL(C.COMPRA_POR_SUPRIMENTO,0) END,
			A.LJ_FLAG_PARTIC_INDIC	=CASE WHEN F.FLAG_NAO_PARTIC_INDIC = 0 THEN 1 ELSE 0 END,
			A.FLAG_ANALISE_FALTAS	=P.FLAG_ANALISE_FALTAS,
			A.STS_PROD_EMP			=p.STS_PROD,
			A.STS_PROD_FILIAL		=C.STS_PROD_FILIAL,
			A.EMAX					=c.EMAX,
			A.ESEG					=c.ESEG,
			A.QTDE_FACEAMENTO		=C.QTDE_FACEAMENTO,
			A.QTDE_FINANCIADO		=C.QTDE_FINANCIADO,
			A.QTDE_LIMITADOR		=C.QTDE_LIMITADOR,
			A.VLR_CUSTO				=C.VLR_CUSTO,
			A.VLR_CUSTO_MD			=C.VLR_CUSTO_MD,
			A.VLR_TABELA			=vlr.VLR_TABELA,
			A.VLR_OFERTA			=vlr.VLR_OFERTA,
			a.FLAG_NAO_PARTIC_INDIC_LINHA = ISNULL(linha.FLAG_NAO_PARTIC_INDIC,0)
		FROM 
			#ANALISE a 
			INNER JOIN  EST_PROD p ON
			a.CD_EMP	= p.CD_EMP AND 
			a.CD_PROD	= p.CD_PROD 
			INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA arv ON
			a.CD_EMP	= arv.CD_EMP AND 
			a.CD_PROD	= arv.CD_PROD 
			INNER JOIN  EST_ARV_MERC_LINHA linha ON
			arv.CD_EMP	= linha.CD_EMP AND 
			arv.CD_ARV_MERC_LINHA	= linha.CD_ARV_MERC_LINHA 
			INNER JOIN  V_EST_PROD_CPL_ESTOQUE c ON
			a.CD_EMP		= c.CD_EMP AND 
			a.CD_FILIAL		= c.CD_FILIAL AND
			a.CD_PROD		= c.CD_PROD  
			
			INNER JOIN  EST_PROD_PRECO vlr ON
			a.CD_EMP		= vlr.CD_EMP AND 
			a.CD_FILIAL		= vlr.CD_FILIAL AND
			a.CD_PROD		= vlr.CD_PROD  

			INNER JOIN  PRC_FILIAL f ON
			a.CD_EMP		= f.CD_EMP AND 
			a.CD_FILIAL		= f.CD_FILIAL  
		WHERE 
			a.DT_VD			=@DT_ATUAL 
			AND a.CD_EMP	=@CD_EMP
			AND a.CD_FILIAL	=@CD_FILIAL; 
	END
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/


	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'REGISTRA A QUANTIDADE DE RESSUPRIMENTO NO DIA', GETDATE()

	UPDATE a SET 
		QT_RESSUP_DIA =	res.QT_RESSUP
	FROM 
		#ANALISE a 
		INNER JOIN (SELECT 
						CD_EMP,
						CD_PROD,
						CD_FIL_DEST CD_FILIAL,
						SUM (QT_SOL) QT_RESSUP
					FROM 
						 V_EST_PROD_TRANSF_IT 
					WHERE 
						DT_TRANSF = @DT_ATUAL
						AND CD_EMP= @CD_EMP 
						AND CD_FIL_DEST = @CD_FILIAL
					GROUP BY 
						CD_EMP,	
						CD_PROD,
						CD_FIL_DEST) res ON 
		a.CD_EMP		= res.CD_EMP AND 
		a.CD_FILIAL		= res.CD_FILIAL AND
		a.CD_PROD		= res.CD_PROD 

	WHERE 
		a.DT_VD			=@DT_ATUAL 
		AND a.CD_EMP	=@CD_EMP
		AND a.CD_FILIAL	=@CD_FILIAL;


	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'REGISTRA A QUANTIDADE DE RESSUPRIMENTO PROX DIA', GETDATE()

	UPDATE a SET 
		QT_RESSUP_PROX_DIA = res.QT_RESSUP
	FROM 
		#ANALISE a 
		INNER JOIN (SELECT 
						CD_EMP,
						CD_PROD,
						CD_FIL_DEST CD_FILIAL,
						SUM (QT_SOL) QT_RESSUP
					FROM 
						 V_EST_PROD_TRANSF_IT 
					WHERE 
						DT_TRANSF = @DT_ATUAL+1
						AND CD_EMP= @CD_EMP 
						AND CD_FIL_DEST = @CD_FILIAL
					GROUP BY 
						CD_EMP,	
						CD_PROD,
						CD_FIL_DEST) res ON 
		a.CD_EMP		= res.CD_EMP AND 
		a.CD_FILIAL		= res.CD_FILIAL AND
		a.CD_PROD		= res.CD_PROD 

	WHERE 
		a.DT_VD			=@DT_ATUAL
		AND a.CD_EMP	=@CD_EMP
		AND a.CD_FILIAL	=@CD_FILIAL;
 
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'REGISTRA A QUANTIDADE DE COMPRA NO DIA', GETDATE()

	UPDATE a SET 
		QT_CP_DIA =	cp.QT_CP
	FROM 
		#ANALISE a 
		INNER JOIN (SELECT     
						EST_PED_CP.CD_EMP, 
						EST_PED_CP.CD_FILIAL, 
						IT.CD_PROD,
						SUM(IT.QT_IT) QT_CP
					FROM    
						 EST_PED_CP  EST_PED_CP						
						INNER JOIN  EST_PED_CP_IT IT ON
						EST_PED_CP.CD_EMP		= IT.CD_EMP AND
						EST_PED_CP.CD_FILIAL	= IT.CD_FILIAL AND
						EST_PED_CP.CD_PED		= IT.CD_PED					
					WHERE   
						EST_PED_CP.STS_PED <> 2
						AND EST_PED_CP.CD_EMP	 = @CD_EMP
						AND EST_PED_CP.CD_FILIAL = @CD_FILIAL
						AND EST_PED_CP.DT_EMI	 = @DT_ATUAL
					GROUP BY 
						EST_PED_CP.CD_EMP, 
						EST_PED_CP.CD_FILIAL, 
						IT.CD_PROD)  cp ON 
						a.CD_EMP		= cp.CD_EMP AND 
						a.CD_FILIAL		= cp.CD_FILIAL AND
						a.CD_PROD		= cp.CD_PROD 
			WHERE 
				a.DT_VD			=@DT_ATUAL 
				AND a.CD_EMP	=@CD_EMP
				AND a.CD_FILIAL	=@CD_FILIAL;
 
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
/*	----------------------------------------------------------------------------------------------------------------------------------------*/
	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'GERA O EXCESSO', GETDATE()

--Gerando Excesso
	IF (DATEADD(DAY, -2, GETDATE()) < @DT_ATUAL)
	BEGIN
		INSERT INTO #EXCESSO	
		SELECT	
			@CD_EMP AS CD_EMP, 
			c.CD_FILIAL, 
			@DT_ATUAL AS DT_ATUAL, 
			c.CD_PROD, 
			s.DS_SIGLA AS CURVA, 
			c.MEDIAF AS QT_MEDIA, 
			ROUND(CASE WHEN c.MEDIAF > 0 THEN 
					((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0)) / (c.MEDIAF)) * 30
				ELSE 
					CONVERT(FLOAT, ((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0)) / 0.001))
				END, 2 ) AS COBERTURA,
			c.QT_EST, 
			0 AS QTDE_EXCESSO,
			c.EMAX LIMITE_EXCESSO,
			c.QT_EST_EM_TERC ,	
			c.QT_EST_DE_TERC ,	
			c.QT_EST_DEPOSITOS ,
			c.MEDIAF,
			0 QT_PEND_ENT,			
			0 QT_PEND_SAI,
			0 QT_DIAS_EXCESSO
		FROM 
			 V_EST_PROD_CPL_ESTOQUE c
			INNER JOIN  EST_PROD_CURVA_SIGLA s ON 
			c.CD_EMP = s.CD_EMP AND 
			c.CD_SIGLA = s.CD_SIGLA
		WHERE 
			c.CD_EMP		=@CD_EMP 
			AND c.CD_FILIAL = @CD_FILIAL;
	END
	ELSE
	BEGIN
		INSERT INTO #EXCESSO	
		SELECT	
			@CD_EMP AS CD_EMP, 
			c.CD_FILIAL, 
			@DT_ATUAL AS DT_ATUAL, 
			c.CD_PROD, 
			s.DS_SIGLA AS CURVA, 
			c.MEDIAF AS QT_MEDIA, 
			ROUND(CASE WHEN C.MEDIAF > 0 THEN 
					((isnull(d.QT_IT ,0)+ isnull(E.QT_IT,0)) / (C.MEDIAF)) * 30
				ELSE 
					CONVERT(FLOAT, ((isnull(d.QT_IT ,0)+ isnull(E.QT_IT,0)) / 0.001))
				END, 2 ) AS COBERTURA,
			d.QT_IT, 
			0 AS QTDE_EXCESSO,
			c.EMAX LIMITE_EXCESSO,
			E.QT_IT ,	
			F.QT_IT ,	
			c.QT_EST_DEPOSITOS ,
			c.MEDIAF,
			0 QT_PEND_ENT,			
			0 QT_PEND_SAI,
			0 QT_DIAS_EXCESSO
		FROM 
		    V_EST_PROD_CPL_ESTOQUE c
			INNER JOIN  EST_PROD_CURVA_SIGLA s ON 
			c.CD_EMP = s.CD_EMP AND 
			c.CD_SIGLA = s.CD_SIGLA
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,0) D
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,2) E
			CROSS APPLY UFD_EST_PROD_CPL_POS_PERIODO(@CD_EMP, @CD_FILIAL, C.CD_PROD, @DT_ATUAL,3) F
		WHERE 
			c.CD_EMP		=@CD_EMP 
			AND c.CD_FILIAL = @CD_FILIAL;
	END
	UPDATE 
		a 
	SET 
		COBERTURA		=e.COBERTURA, 
		QT_EST			=e.QT_EST, 
		LIMITE_EXCESSO	=e.EMAX, 
		QT_MEDIA_VD		=e.MEDIAF,
		QT_EXCESSO	    = CASE WHEN e.MEDIAF = 0 AND e.QT_EST > 0 THEN 
								e.QT_EST
							WHEN e.QT_EST > ((e.MEDIAF/30.0000) *  e.EMAX) THEN 
								ROUND(e.QT_EST - ((e.MEDIAF/30.0000) *  e.EMAX),0) 
							ELSE 
								0 
							END, 
		QT_DIAS_EXCESSO =	CASE WHEN e.MEDIAF = 0 AND e.QT_EST > 0 THEN 
								120		
							WHEN e.COBERTURA > e.EMAX THEN 
								ROUND((e.COBERTURA-e.EMAX) ,0) 
							ELSE 
								0 
							END
	FROM 
		#EXCESSO e 
		INNER JOIN #ANALISE a ON 
		e.CD_EMP=a.CD_EMP AND 
		e.CD_FILIAL=a.CD_FILIAL AND 
		e.CD_PROD=a.CD_PROD AND 
		e.DT_ATUAL=a.DT_VD;
 

		INSERT INTO LOG_ANALISE_DIARIA 
		SELECT @CD_FILIAL, 'REGISTRA OS DADOS NA TABELA ANALISE DIARIO', GETDATE()
	
	
	INSERT INTO EST_PROD_CPL_ANALISE_DIARIO
		(CD_EMP,CD_FILIAL,DT_VD,CD_PROD, PART_QTDE,QT_VD_DIA, 
			QT_MEDIA_VD,PART_VLR, VLR_MEDIO_VD,COBERTURA,QT_EST,QT_EXCESSO,LIMITE_EXCESSO,FLAG_PART_INDIC,QT_EST_EM_TERC ,	
			QT_EST_DE_TERC,QT_EST_DEPOSITOS ,MEDIAF,QT_PEND_ENT,QT_PEND_SAI,QT_RESSUP_DIA,
			QT_CP_DIA,CD_SIGLA, VLR_DESC_VD,QT_DIAS_EXCESSO,QT_RESSUP_PROX_DIA,CD_FABRIC,CD_ARV_MERC_LINHA, 
			COMPRA_POR_SUPRIMENTO,LJ_FLAG_PARTIC_INDIC,FLAG_ANALISE_FALTAS,
			STS_PROD_EMP,STS_PROD_FILIAL,EMAX,ESEG,QTDE_FACEAMENTO,QTDE_FINANCIADO,QTDE_LIMITADOR, DT_CAD,
			VLR_CUSTO,VLR_CUSTO_MD,VLR_TABELA,VLR_OFERTA,FLAG_NAO_PARTIC_INDIC_LINHA)
		SELECT 
			CD_EMP,	
			CD_FILIAL, 
			DT_VD, 
			CD_PROD, 
			PART_QTDE, 
			QT_VD_DIA, 
			QT_MEDIA_VD, 
			PART_VLR, 
			VLR_MEDIO_VD, 
			ISNULL(COBERTURA,0) COBERTURA, 
			QT_EST, 
			QT_EXCESSO, 
			LIMITE_EXCESSO,
			FLAG_PART_INDIC,
			QT_EST_EM_TERC ,	
			QT_EST_DE_TERC ,	
			QT_EST_DEPOSITOS ,
			MEDIAF,
			QT_PEND_ENT,
			QT_PEND_SAI,
			QT_RESSUP_DIA,
			QT_CP_DIA,
			CD_SIGLA,
			VLR_DESC_VD,
			QT_DIAS_EXCESSO,
			QT_RESSUP_PROX_DIA,
			CD_FABRIC,
			CD_ARV_MERC_LINHA,
			COMPRA_POR_SUPRIMENTO,
			LJ_FLAG_PARTIC_INDIC,
			FLAG_ANALISE_FALTAS,
			STS_PROD_EMP,
			STS_PROD_FILIAL,
			EMAX,
			ESEG,
			QTDE_FACEAMENTO,
			QTDE_FINANCIADO,
			QTDE_LIMITADOR,
			GETDATE() DT_CAD,
			ISNULL(VLR_CUSTO,0),
			ISNULL(VLR_CUSTO_MD,0),
			ISNULL(VLR_TABELA,0),
			ISNULL(VLR_OFERTA,0),
			FLAG_NAO_PARTIC_INDIC_LINHA
		FROM 
			#ANALISE
		WHERE
			DT_VD=@DT_ATUAL 
			AND CD_EMP=@CD_EMP
			AND CD_FILIAL=@CD_FILIAL;
 

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'MONTA TABELA TEMPORARIA PARA ANALISE DE DIAS EM FALTA', GETDATE()

	SELECT
		@DT_INI_MES=dbo.F_INICIO_MES(@DT_ATUAL),
		@DT_FIM_MES= @DT_INI_MES;
 
	WHILE @DT_FIM_MES <= @DT_ATUAL
	BEGIN 
		INSERT INTO #BASE2
		SELECT  
			CD_FILIAL, 
			CD_PROD, 
			SUM (QT_DIAS_CALCULO) QT_DIAS_CALCULO ,
			SUM (QT_DIAS_FALTA ) QT_DIAS_FALTA
		FROM
			(SELECT 
				CD_EMP,
				CD_FILIAL, 
				CD_PROD, 
				1 QT_DIAS_CALCULO,
				0 QT_DIAS_FALTA
			FROM 
				EST_PROD_CPL_ANALISE_DIARIO 
			WHERE 
				CD_EMP=@CD_EMP 
				AND DT_VD = @DT_FIM_MES
				AND CD_FILIAL =@CD_FILIAL 
			UNION ALL
			SELECT 
				CD_EMP,
				CD_FILIAL, 
				CD_PROD, 
				0  QT_DIAS_CALCULO,
				1 QT_DIAS_FALTA
			FROM 
				EST_PROD_CPL_ANALISE_DIARIO 
			WHERE 
				CD_EMP=@CD_EMP 
				AND DT_VD = @DT_FIM_MES
				AND CD_FILIAL =@CD_FILIAL
				and QT_EST <1) TBL
			GROUP BY  
				CD_FILIAL, 
				CD_PROD;
			SET @DT_FIM_MES = @DT_FIM_MES +1
		END
 
	INSERT INTO #BASE
	SELECT  
		CD_FILIAL, 
		CD_PROD, 
		SUM (QT_DIAS_CALCULO) QT_DIAS_CALCULO ,
		SUM (QT_DIAS_FALTA ) QT_DIAS_FALTA
	FROM 
		#BASE2
	GROUP BY 	
		CD_FILIAL, 
		CD_PROD;

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'REGISTRA ANALISE DE DIAS EM FALTA', GETDATE()
	UPDATE 
		m 
	SET 
		QT_DIAS_FALTA=ISNULL(d.QT_DIAS_FALTA,0), 
		QT_DIAS_CALCULO=ISNULL(d.QT_DIAS_CALCULO,0),
		DT_CALCULO_DIARIO=GETDATE()
	FROM 
		EST_PROD_CPL_ANALISE m 
		INNER JOIN #BASE d ON 
		d.CD_FILIAL	= m.CD_FILIAL AND 
		d.CD_PROD	= m.CD_PROD 
	WHERE 
		m.CD_EMP=@CD_EMP 
		AND m.CD_FILIAL=@CD_FILIAL
		AND m.ANO=YEAR(@DT_ATUAL) 
		AND m.MES=MONTH(@DT_ATUAL);

	INSERT INTO LOG_ANALISE_DIARIA 
	SELECT @CD_FILIAL, 'FINAL DO PROCEDIMENTO', GETDATE()


